/************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010, All Rights Reserved  *
*************************************************************************

************************************************************************
*                                                                      *
*        Standard Software Flash Driver For FTFL           		         *
*                                                                      *
* FILE NAME     :  SSD_FTFL_Internal.h                                 *
* DATE          :  August 16,2010                                      *
*                                                                      *
* AUTHOR        :  FPT Team                                            *
* E-mail        :  b28216@freescale.com                                *
*                                                                      *
************************************************************************/

/************************** CHANGES ***********************************
0.0.1    	06.09.2010    	FPT Team            		Initial Version
0.1.0    	06.11.2010    	FPT Team            		Finalize to 0.1.0 
0.1.1     08.16.2010      FPT Team                Update some macros for
                                                  FTFL_P2_256K_256K_4K
                                                  derivative
***********************************************************************/

#ifndef _SSD_FTFL_INTERNAL_H_
#define _SSD_FTFL_INTERNAL_H_

/*--------------- FTFL Flash Module Memory Offset Map -----------------*/				 
#if(FTFL_LL_128K_32K_2K == FLASH_DERIVATIVE)    //LLTV2 - big endian
	/* Flash Status Register (FSTAT)*/
	#define FTFL_FSTAT_OFFSET              0x00000003
	#define FTFL_FSTAT_CCIF              	 0x80
	#define FTFL_FSTAT_RDCOLERR          	 0x40
	#define FTFL_FSTAT_ACCERR				       0x20
	#define FTFL_FSTAT_FPVIOL			      	 0x10
	#define FTFL_FSTAT_MGSTAT0		       	 0x01

	/* Flash configuration register (FCNFG)*/
	#define FTFL_FCNFG_OFFSET              0x00000002
	#define FTFL_FCNFG_CCIE                0x80
	#define FTFL_FCNFG_RDCOLLIE			       0x40
	#define FTFL_FCNFG_ERSAREQ             0x20
	#define FTFL_FCNFG_ERSSUSP             0x10
	#define FTFL_FCNFG_RAMRDY              0x02
	#define FTFL_FCNFG_EEERDY              0x01

	/* Flash security register (FSEC) */
	#define FTFL_FSEC_OFFSET               0x00000001
	#define FTFL_FSEC_KEYEN                0xC0
	#define FTFL_FSEC_FSLACC				       0x0C
	#define FTFL_FSEC_SEC                  0x03

	/* Flash Option Register (FOPT) */
	#define FTFL_FOPT_OFFSET                0x00000000

	/* Flash common command object registers (FCCOB0-B) */
	#define FTFL_FCCOB0_OFFSET             0x00000004
	#define FTFL_FCCOB1_OFFSET             0x00000005
	#define FTFL_FCCOB2_OFFSET             0x00000006
	#define FTFL_FCCOB3_OFFSET             0x00000007
	#define FTFL_FCCOB4_OFFSET             0x00000008
	#define FTFL_FCCOB5_OFFSET             0x00000009
	#define FTFL_FCCOB6_OFFSET             0x0000000A
	#define FTFL_FCCOB7_OFFSET             0x0000000B
	#define FTFL_FCCOB8_OFFSET             0x0000000C
	#define FTFL_FCCOB9_OFFSET             0x0000000D
	#define FTFL_FCCOBA_OFFSET             0x0000000E
	#define FTFL_FCCOBB_OFFSET             0x0000000F

	/* P-Flash protection registers (FPROT0-3) */
	#define FTFL_FPROT0_OFFSET             0x00000010
	#define FTFL_FPROT1_OFFSET             0x00000011
	#define FTFL_FPROT2_OFFSET             0x00000012
	#define FTFL_FPROT3_OFFSET             0x00000013

	/* D-Flash protection registers (FDPROT) */
	#define FTFL_FDPROT_OFFSET             0x00000014

	/* EERAM Protection Register (FEPROT)  */
	#define FTFL_FEPROT_OFFSET             0x00000015
#else	//Nevis products - little endian
	/* Flash Status Register (FSTAT)*/
	#define FTFL_FSTAT_OFFSET              0x00000000
#if	!defined(FTFL_FSTAT_CCIF)	
	#define FTFL_FSTAT_CCIF              	 0x80
	#define FTFL_FSTAT_RDCOLERR          	 0x40
	#define FTFL_FSTAT_ACCERR				 0x20
	#define FTFL_FSTAT_FPVIOL			     0x10
	#define FTFL_FSTAT_MGSTAT0		       	 0x01
#endif
	/* Flash configuration register (FCNFG)*/
	#define FTFL_FCNFG_OFFSET              0x00000001
#if	!defined(FTFL_FCNFG_CCIE)	
	#define FTFL_FCNFG_CCIE                0x80
	#define FTFL_FCNFG_RDCOLLIE			   0x40
	#define FTFL_FCNFG_ERSAREQ             0x20
	#define FTFL_FCNFG_ERSSUSP             0x10
	#define FTFL_FCNFG_RAMRDY              0x02
	#define FTFL_FCNFG_EEERDY              0x01
#endif
	/* Flash security register (FSEC) */
	#define FTFL_FSEC_OFFSET               0x00000002

#if	!defined(FTFL_FSEC_KEYEN)		
	#define FTFL_FSEC_KEYEN                0xC0
	#define FTFL_FSEC_FSLACC		       0x0C
	#define FTFL_FSEC_SEC                  0x03
#endif
	/* Flash Option Register (FOPT) */
	#define FTFL_FOPT_OFFSET                0x00000003

	/* Flash common command object registers (FCCOB0-B) */
	#define FTFL_FCCOB0_OFFSET             0x00000007
	#define FTFL_FCCOB1_OFFSET             0x00000006
	#define FTFL_FCCOB2_OFFSET             0x00000005
	#define FTFL_FCCOB3_OFFSET             0x00000004
	#define FTFL_FCCOB4_OFFSET             0x0000000B
	#define FTFL_FCCOB5_OFFSET             0x0000000A
	#define FTFL_FCCOB6_OFFSET             0x00000009
	#define FTFL_FCCOB7_OFFSET             0x00000008
	#define FTFL_FCCOB8_OFFSET             0x0000000F
	#define FTFL_FCCOB9_OFFSET             0x0000000E
	#define FTFL_FCCOBA_OFFSET             0x0000000D
	#define FTFL_FCCOBB_OFFSET             0x0000000C

	/* P-Flash protection registers (FPROT0-3) */
	#define FTFL_FPROT0_OFFSET             0x00000013
	#define FTFL_FPROT1_OFFSET             0x00000012
	#define FTFL_FPROT2_OFFSET             0x00000011
	#define FTFL_FPROT3_OFFSET             0x00000010

	/* D-Flash protection registers (FDPROT) */
	#define FTFL_FDPROT_OFFSET             0x00000017

	/* EERAM Protection Register (FEPROT)  */
	#define FTFL_FEPROT_OFFSET             0x00000016
#endif//Nevis products - little endian

/*------------- Flash hardware algorithm operation commands -------------*/
#define FTFL_VERIFY_BLOCK		       0x00
#define FTFL_VERIFY_SECTION  		   0x01
#define FTFL_PROGRAM_CHECK		       0x02
#define FTFL_READ_RESOURCE             0x03
#define FTFL_PROGRAM_BYTE              0x04
#define FTFL_PROGRAM_WORD              0x05
#define FTFL_PROGRAM_LONGWORD          0x06
#define FTFL_ERASE_BLOCK	             0x08
#define FTFL_ERASE_SECTOR		           0x09
#define FTFL_PROGRAM_SECTION           0x0B
#define FTFL_VERIFY_ALL_BLOCK          0x40
#define FTFL_READ_ONCE                 0x41
#define FTFL_PROGRAM_ONCE    			     0x43
#define FTFL_ERASE_ALL_BLOCK           0x44
#define FTFL_SECURITY_BY_PASS          0x45
#define FTFL_PROGRAM_PARTITION		     0x80
#define FTFL_SET_EERAM    			       0x81

/* Flash margin read settings */
#define FTFL_MARGIN_NORMAL             0x0000
#define FTFL_USER_MARGIN_LEVEL1        0x0001
#define FTFL_USER_MARGIN_LEVEL0        0x0002
#define FTFL_FACTORY_MARGIN_LEVEL0     0x0003
#define FTFL_FACTORY_MARGIN_LEVEL1     0x0004

#endif  /* _SSD_FTFL_INTERNAL_H_ */